<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Certificate Verification</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        /* Basic Reset */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            background: url('img/background_industry.jpg') no-repeat center center fixed;
            background-size: cover;
            font-family: Arial, sans-serif;
        }

        .header {
    display: flex;
                background-color: #002d9c;
 color: white;
    align-items: center;         /* vertically align items */
    gap: 16px;                   /* space between image and text */
    padding: 20px;               /* optional */
    flex-wrap: nowrap;          /* prevent wrapping on mobile */
}

.header img {
    width: 40px;                /* or any size that fits mobile view */
    height: auto;
    flex-shrink: 0;             /* prevent image from shrinking */
}

.header h1 {
    margin: 0;
    font-size: 24px;            /* responsive size for mobile */
    font-weight: normal;
    font-family: sans-serif;
    white-space: nowrap;        /* optional: prevent wrapping */
}

.header .light-gray {
    color: #777;
}

.header p {
    margin: 4px 0 0;
    font-size: 14px;
    line-height: 1.4;
}
        .certificate-box {
            width: 90%;
            max-width: 600px;
            background: white;
            margin: 30px auto;
            border-radius: 20px 20px 0 0;
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
            overflow: hidden;
        }

        .tick-header {
            background: linear-gradient(to bottom, #d2d2d2, #999999);
            padding: 40px 0 20px;
            position: relative;
            text-align: center;
            border-radius: 20px 20px 0 0;
        }

    .tick-circle {
    width: 40px;
    height: 40px;
    background: transparent;           /* transparent inner */
    border: 2px solid #ffffff;         /* green border */
    border-radius: 50%;
    display: flex;                     /* flexbox for centering */
    align-items: center;
    justify-content: center;
    position: relative;
    margin: auto;
    top: -25px;
}

.tick-circle::before {
    content: '';
    display: block;
    width: 36px;
    height: 36px;
    background-image: url('img/tick1.png'); /* ✅ your image path here */
    background-size: contain;
    background-repeat: no-repeat;
    background-position: center;
}
        .light-gray {
    color: #777; /* or try #888 or #999 for lighter/darker gray */
}

        
     

        .error-circle::before {
            content: '✖';
            color: #d9534f;
            font-size: 28px;
        }

        .content {
            padding: 30px 20px 40px;
        }

       .content p {
    margin: 0;
    line-height: 1.5;
    font-size: 14px;
}

        .content p span {
            font-weight: bold;
        }

        .booo {
            color: #000;
            font-family: Arial, sans-serif;
            padding: 10px 15px;
            font-size: 14px;
            line-height: 1.4;
            text-align: center;
             font-weight: bold;
        }

        .not-found {
            text-align: center;
            color: #d9534f;
            font-size: 18px;
            font-weight: bold;
        }
        
        

       @media (max-width: 600px) {
    .certificate-box {
        width: 100%;
        margin: 20px 0;
        border-radius: 20;
        box-shadow: none;
    }
body {
        background: url('img/mobile.JPG') no-repeat top center;
        background-size: cover; /* or 'cover' depending on your goal */
        background-attachment: scroll;
        font-family: Arial, sans-serif;
        min-height: 100vh;
        margin: 0;
        padding: 0;
    }
    .header {
        display: flex;
        flex-direction: row;         /* keep side by side */
        align-items: center;
        gap: 12px;
        padding: 15px;
        text-align: left;
    }

    .header img {
        width: 60px;                 /* 🔼 make fingerprint image larger */
        height: 85px;                /* force square if needed */
        flex-shrink: 0;
    }

    .header h1 {
        font-size: 16px;             /* 🔽 make heading smaller */
        margin: 0;
    }

    .header p {
        font-size: 12px;             /* 🔽 make paragraph smaller */
        margin: 4px 0 0;
        line-height: 1.4;
    }

    .content {
        padding: 20px 15px 30px;
    }

    .content p {
        font-size:15px;
    }

    .booo {
        font-size: 12px;
    }
}

.footer-link {
    display: inline-block;        /* keeps text stacked */
    text-align: center;           /* centers "Visit" above link */
    margin: 30px 20px;            /* space from top and left */
}

.footer-label {
    font-size: 14px;
    color: #000;
    margin-bottom: 4px;
}

.footer-link a {
    color: #000;                  /* black link */
    text-decoration: none;
    font-weight: bold;
    font-size: 14px;
}

.footer-link a:hover {
    text-decoration: underline;   /* optional hover effect */
}
    </style>
</head>
<body>

   <div class="header">
    <img src="img/fingerprint.png" alt="Fingerprint Icon">
    <div>
        <h1>
            Authenticate <span class="light-gray">your document</span>
        </h1>
        <p>
            Thank you for submitting your document for verification.<br>
            Please find below the result of your request.
        </p>
    </div>
</div>

<?php
$certId = $_GET['cert_id'] ?? '';

$conn = new mysqli("localhost", "u852319134_7uIfI", "Redapple@2917", "u852319134_vxDbg");

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT * FROM certificates WHERE cert_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $certId);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    if (strtolower(trim($row['qr_code_status'])) === 'validated') {
        echo "
        <div class='certificate-box'>
            <div class='tick-header'>
                <div class='tick-circle'></div>
            </div>
            <div class='content'>
                <p><span>Deliverable Id :</span><br>{$row['cert_id']}</p>
                <p><span>Published on :</span><br>{$row['published_on']}</p>
                <p><span>QR Code Status :</span><br>{$row['qr_code_status']}</p>
                <p><span>NAME :</span><br>{$row['name']}</p>
                <p><span>ID :</span><br>{$row['person_id']}</p>
                <p><span>ISSUED ON :</span><br>{$row['issued_on']}</p>
                <p><span>VALID UNTIL :</span><br>{$row['valid_until']}</p>
                <p><span>TYPE :</span><br>{$row['course_type']}</p>
                <p><span>MODEL :</span><br>{$row['model']}</p>
                <p><span>COMPANY :</span><br>{$row['company']}</p>
                <p><span>TRAINING LOCATION :</span><br>{$row['training_location']}</p>
                <p><span>TRAINER :</span><br>{$row['trainer_name']}</p>

                <div class='booo'>
                    For any further information on this document, please contact the issuer of the docoment.
                </div>
            </div>
          
        </div>";
    } else {
        echo "
        <div class='certificate-box'>
            <div class='tick-header'>
                <div class='tick-circle error-circle'></div>
            </div>
            <div class='content'>
                <p class='not-found'>❌ Certificate not found or QR code is not validated.</p>
            </div>
        </div>";
    }
} else {
    echo "
    <div class='certificate-box'>
        <div class='tick-header'>
            <div class='tick-circle error-circle'></div>
        </div>
        <div class='content'>
            <p class='not-found'>❌ Certificate not found.</p>
        </div>
    </div>";
}
?>

<script>
    document.addEventListener('contextmenu', e => e.preventDefault());
    document.onkeydown = function(e) {
        if (e.keyCode === 123 || (e.ctrlKey && e.shiftKey && e.keyCode === 'I'.charCodeAt(0))) {
            return false;
        }
    }
</script>

<div class="footer-link">
    <div class="footer-label">Visit</div>
    <a href="https://www.bureauveritas.com" target="_blank">
        Bureau Veritas Website
    </a>
</div>

</body>
</html>
