<?php
require_once __DIR__ . '/config.php';
session_start();

if (!empty($_SESSION['admin'])) {
    header('Location: /testDoc/list_certificates.php'); // adjust if needed
    exit;
}

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = $_POST['username'] ?? '';
    $pass = $_POST['password'] ?? '';

    if ($user === ADMIN_USERNAME && password_verify($pass, ADMIN_PASSWORD_HASH)) {
        session_regenerate_id(true);
        $_SESSION['admin'] = true;
        $_SESSION['admin_user'] = ADMIN_USERNAME;

        $redirect = $_GET['redirect'] ?? '/testDoc/list_certificates.php'; // fallback path
        header('Location: ' . $redirect);
        exit;
    } else {
        $err = 'Invalid username or password';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Login</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
  <style>
    * {
      box-sizing: border-box;
      font-family: 'Inter', sans-serif;
    }

    body {
      margin: 0;
      background: #f4f7fa;
      display: flex;
      height: 100vh;
      justify-content: center;
      align-items: center;
    }

    .login-container {
      background: #fff;
      padding: 30px 40px;
      border-radius: 8px;
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
      width: 100%;
      max-width: 400px;
    }

    .login-container h2 {
      margin-top: 0;
      margin-bottom: 20px;
      font-weight: 600;
      font-size: 24px;
      color: #333;
      text-align: center;
    }

    .form-group {
      margin-bottom: 18px;
    }

    label {
      display: block;
      font-weight: 500;
      margin-bottom: 6px;
      color: #555;
    }

    input[type="text"],
    input[type="password"] {
      width: 100%;
      padding: 12px;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 14px;
      transition: border-color 0.2s;
    }

    input:focus {
      border-color: #007bff;
      outline: none;
    }

    .error {
      color: #d9534f;
      font-size: 14px;
      margin-bottom: 15px;
      text-align: center;
    }

    .btn {
      background-color: #007bff;
      color: white;
      padding: 12px;
      border: none;
      border-radius: 6px;
      width: 100%;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      transition: background-color 0.2s;
    }

    .btn:hover {
      background-color: #0056b3;
    }

    .footer-note {
      margin-top: 20px;
      font-size: 12px;
      color: #999;
      text-align: center;
    }
  </style>
</head>
<body>

<div class="login-container">
  <h2>Admin Login</h2>

  <?php if ($err): ?>
    <div class="error"><?= htmlspecialchars($err) ?></div>
  <?php endif; ?>

  <form method="POST" action="">
    <div class="form-group">
      <label for="username">Username</label>
      <input type="text" name="username" id="username" required autofocus>
    </div>

    <div class="form-group">
      <label for="password">Password</label>
      <input type="password" name="password" id="password" required>
    </div>

    <button type="submit" class="btn">Login</button>
  </form>

  <div class="footer-note">
    &copy; <?= date('Y') ?> BeauruVirtas
  </div>
</div>

</body>
</html>
