<?php
$conn = new mysqli("localhost", "u852319134_7uIfI", "Redapple@2917", "u852319134_vxDbg");
$result = $conn->query("SELECT * FROM certificates ORDER BY issued_on DESC");
require_once __DIR__ . '/auth.php';
require_admin();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Certificate List</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #eef2f5;
            padding: 40px;
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        .search-container {
            max-width: 700px;
            margin: 0 auto 30px;
            text-align: center;
        }

        .search-container input[type="text"] {
            width: 60%;
            padding: 10px 15px;
            font-size: 16px;
            border-radius: 8px;
            border: 1px solid #ccc;
        }

        a.add-btn {
            display: block;
            width: 200px;
            margin: 20px auto;
            padding: 12px;
            background-color: #28a745;
            color: white;
            text-align: center;
            border-radius: 6px;
            text-decoration: none;
        }

        table {
            width: 100%;
            max-width: 1100px;
            margin: auto;
            border-collapse: collapse;
            background: white;
            border-radius: 10px;
            overflow: hidden;
        }

        th, td {
            padding: 14px;
            border-bottom: 1px solid #ddd;
            text-align: left;
        }

        th {
            background-color: #007BFF;
            color: white;
        }

        td.actions a {
            margin-right: 10px;
            color: #007BFF;
            text-decoration: none;
        }

        td.actions a:hover {
            text-decoration: underline;
        }

        .status {
            font-weight: bold;
        }

        .validated {
            color: green;
        }

        .non-validated {
            color: red;
        }

        .no-result {
            text-align: center;
            margin-top: 30px;
            font-size: 18px;
            color: #666;
        }
    </style>
</head>
<body>

<h2>All Certificates</h2>

<!-- Search bar (client-side) -->
<div class="search-container">
    <input type="text" id="searchInput" placeholder="Search by Name or Certificate ID...">
</div>

<a class="add-btn" href="add_certificate.php">+ Add New Certificate</a>

<table id="certificateTable">
    <thead>
        <tr>
            <th>Certificate ID</th>
            <th>Name</th>
            <th>Issued On</th>
            <th>QR Status</th>
             <th>QR URL</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= htmlspecialchars($row['cert_id']) ?></td>
            <td><?= htmlspecialchars($row['name']) ?></td>
            <td><?= htmlspecialchars($row['issued_on']) ?></td>
            <td class="status <?= $row['qr_code_status'] === 'Validated' ? 'validated' : 'non-validated' ?>">
                <?= htmlspecialchars($row['qr_code_status']) ?>
            </td>
            <td><?= htmlspecialchars($row['br_code_url']) ?></td>
            <td class="actions">
                <a href="edit_certificate.php?id=<?= urlencode($row['cert_id']) ?>">Edit</a>
                <a href="delete_certificate.php?id=<?= urlencode($row['cert_id']) ?>" onclick="return confirm('Are you sure you want to delete this certificate?');">Delete</a>
            </td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<!-- JavaScript for live search -->
<script>
    const searchInput = document.getElementById("searchInput");
    const table = document.getElementById("certificateTable");
    const rows = table.getElementsByTagName("tr");

    searchInput.addEventListener("keyup", function () {
        const filter = searchInput.value.toLowerCase();

        for (let i = 1; i < rows.length; i++) {
            const certId = rows[i].cells[0].textContent.toLowerCase();
            const name = rows[i].cells[1].textContent.toLowerCase();

            if (certId.includes(filter) || name.includes(filter)) {
                rows[i].style.display = "";
            } else {
                rows[i].style.display = "none";
            }
        }
    });
</script>

</body>
</html>
