<?php
// ==== OLD HOST DB (Local or current server) ====
$oldDb = new mysqli("localhost", "u852319134_7uIfI", "Redapple@2917", "u852319134_vxDbg");
if ($oldDb->connect_error) {
    die("Old DB Connection failed: " . $oldDb->connect_error);
}

// ==== NEW HOST DB (Remote Hostinger Account) ====
// Note: You must enable **remote MySQL access** on your new Hostinger DB
$newDb = new mysqli("srv1135.hstgr.io", "u540368930_macrotelecomp", "myAppleis0", "u540368930_muslimsaqid");
if ($newDb->connect_error) {
    die("New DB Connection failed: " . $newDb->connect_error);
}

// ======== Get POSTed data from form submission ========
$cert_id           = $_POST['cert_id'];
$published_on      = $_POST['published_on'];
$qr_code_status    = $_POST['qr_code_status'];
$name              = $_POST['name'];
$person_id         = $_POST['person_id'];
$issued_on         = $_POST['issued_on'];
$valid_until       = $_POST['valid_until'];
$course_type       = $_POST['course_type'];
$model             = $_POST['model'];
$company           = $_POST['company'];
$training_location = $_POST['training_location'];
$trainer_name      = $_POST['trainer_name'];

// Generate br_code_url
$domain     = "https://yourdomain.com";
$folder     = "myfoldername"; // e.g., certificate
$file       = "view_certificate.php";
$br_code_url = $domain . "/" . $folder . "/" . $file . "?cert_id=" . urlencode($cert_id);

// ======== Insert into OLD database ========
$oldStmt = $oldDb->prepare("INSERT INTO certificates 
(cert_id, published_on, qr_code_status, name, person_id, issued_on, valid_until, course_type, model, company, training_location, trainer_name, br_code_url)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

$oldStmt->bind_param("sssssssssssss",
    $cert_id, $published_on, $qr_code_status, $name, $person_id,
    $issued_on, $valid_until, $course_type, $model, $company,
    $training_location, $trainer_name, $br_code_url
);

$insertedOld = $oldStmt->execute();


// ======== Insert into NEW database ========
$newStmt = $newDb->prepare("INSERT INTO certificates 
(cert_id, published_on, qr_code_status, name, person_id, issued_on, valid_until, course_type, model, company, training_location, trainer_name, br_code_url)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

$newStmt->bind_param("sssssssssssss",
    $cert_id, $published_on, $qr_code_status, $name, $person_id,
    $issued_on, $valid_until, $course_type, $model, $company,
    $training_location, $trainer_name, $br_code_url
);

$insertedNew = $newStmt->execute();


// ======== Final Result ========
if ($insertedOld && $insertedNew) {
    echo "<p style='color:green;'>✅ Certificate inserted into both old and new databases successfully.</p>";
    echo "<p><strong>Barcode URL:</strong> <a href='$br_code_url' target='_blank'>$br_code_url</a></p>";
} else {
    echo "<p style='color:red;'>❌ Failed to insert certificate.</p>";
    echo "<p>Old DB error: " . $oldStmt->error . "</p>";
    echo "<p>New DB error: " . $newStmt->error . "</p>";
}
?>