<?php
$conn = new mysqli("localhost", "u852319134_7uIfI", "Redapple@2917", "u852319134_vxDbg");

$certId = $_GET['id'] ?? '';
$stmt = $conn->prepare("SELECT * FROM certificates WHERE cert_id = ?");
$stmt->bind_param("s", $certId);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

if (!$row) {
    echo "Certificate not found.";
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Certificate</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f2f2f2;
            padding: 40px;
        }

        .container {
            max-width: 700px;
            margin: auto;
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        }

        h2 {
            text-align: center;
            color: #333;
        }

        label {
            font-weight: bold;
            display: block;
            margin-top: 15px;
            color: #444;
        }

        input, select {
            width: 100%;
            padding: 10px;
            margin-top: 6px;
            border: 1px solid #ccc;
            border-radius: 8px;
            font-size: 15px;
        }

        button {
            margin-top: 30px;
            width: 100%;
            padding: 12px;
            background-color: #007BFF;
            border: none;
            color: white;
            font-size: 16px;
            border-radius: 8px;
            cursor: pointer;
        }

        button:hover {
            background-color: #0056b3;
        }

        a {
            display: block;
            text-align: center;
            margin-top: 20px;
            text-decoration: none;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Edit Certificate</h2>
    <form action="update_certificate.php" method="post">
        <input type="hidden" name="cert_id" value="<?= htmlspecialchars($row['cert_id']) ?>">

        <label>Published On</label>
        <input type="date" name="published_on" value="<?= htmlspecialchars($row['published_on']) ?>">

        <label>QR Code Status</label>
        <select name="qr_code_status">
            <option value="Validated" <?= $row['qr_code_status'] === 'Validated' ? 'selected' : '' ?>>Validated</option>
            <option value="Non-Validated" <?= $row['qr_code_status'] === 'Non-Validated' ? 'selected' : '' ?>>Non-Validated</option>
        </select>

        <label>Name</label>
        <input type="text" name="name" value="<?= htmlspecialchars($row['name']) ?>">

        <label>Person ID</label>
        <input type="text" name="person_id" value="<?= htmlspecialchars($row['person_id']) ?>">
        
          <label>QR COde URL</label>
        <input type="text" name="br_code_url" value="<?= htmlspecialchars($row['br_code_url']) ?>">

        <label>Issued On</label>
        <input type="date" name="issued_on" value="<?= htmlspecialchars($row['issued_on']) ?>">

        <label>Valid Until</label>
        <input type="date" name="valid_until" value="<?= htmlspecialchars($row['valid_until']) ?>">

        <label>Course Type</label>
        <input type="text" name="course_type" value="<?= htmlspecialchars($row['course_type']) ?>">

        <label>Model</label>
        <input type="text" name="model" value="<?= htmlspecialchars($row['model']) ?>">

        <label>Company</label>
        <input type="text" name="company" value="<?= htmlspecialchars($row['company']) ?>">

        <label>Training Location</label>
        <input type="text" name="training_location" value="<?= htmlspecialchars($row['training_location']) ?>">

        <label>Trainer Name</label>
        <input type="text" name="trainer_name" value="<?= htmlspecialchars($row['trainer_name']) ?>">

        <button type="submit">Update Certificate</button>
    </form>
    <a href="list_certificates.php">← Back to List</a>
</div>

</body>
</html>
