<!DOCTYPE html>
<html>
<head>
    <title>Add Certificate</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
            margin: 0;
            padding: 40px;
        }

        .container {
            max-width: 700px;
            margin: auto;
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        }

        h2 {
            text-align: center;
            margin-bottom: 25px;
            color: #333;
        }

        label {
            font-weight: bold;
            display: block;
            margin-top: 15px;
            color: #555;
        }

        input, select {
            width: 100%;
            padding: 10px;
            margin-top: 6px;
            border: 1px solid #ccc;
            border-radius: 8px;
            font-size: 15px;
        }

        button {
            margin-top: 30px;
            width: 100%;
            padding: 12px;
            background-color: #007BFF;
            border: none;
            color: white;
            font-size: 16px;
            border-radius: 8px;
            cursor: pointer;
        }

        button:hover {
            background-color: #0056b3;
        }

        a {
            display: block;
            text-align: center;
            margin-top: 20px;
            text-decoration: none;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Add New Certificate</h2>
    <form action="fetch.php" method="post">
        <label>Certificate ID</label>
        <input type="text" name="cert_id" required>

        <label>Published On</label>
        <input type="date" name="published_on">

        <label>QR Code Status</label>
        <select name="qr_code_status">
            <option value="Validated">Validated</option>
            <option value="Non-Validated">Non-Validated</option>
        </select>

        <label>Name</label>
        <input type="text" name="name">

        <label>Person ID</label>
        <input type="text" name="person_id">

        <label>Issued On</label>
        <input type="date" name="issued_on">

        <label>Valid Until</label>
        <input type="date" name="valid_until">

        <label>Course Type</label>
        <input type="text" name="course_type">

        <label>Model</label>
        <input type="text" name="model">

        <label>Company</label>
        <input type="text" name="company">

        <label>Training Location</label>
        <input type="text" name="training_location">

        <label>Trainer Name</label>
        <input type="text" name="trainer_name">

        <button type="submit">Add Certificate</button>
    </form>
    <a href="list_certificates.php">← Back to List</a>
</div>

</body>
</html>
