<?php
$certId = $_GET['cert_id'];

$conn = new mysqli("localhost", "u852319134_7uIfI", "Redapple@2917", "u852319134_vxDbg");

$sql = "SELECT * FROM certificates WHERE cert_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $certId);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo "<!DOCTYPE html>
    <html>
    <head>
        <title>Certificate Details</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                background: #f0f0f0;
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
            }
            .certificate-box {
                background: #ffffff;
                padding: 30px;
                border-radius: 10px;
                box-shadow: 0 0 15px rgba(0,0,0,0.1);
                width: 90%;
                max-width: 500px;
                text-align: center;
            }
            .certificate-box h2 {
                margin-bottom: 20px;
            }
            .certificate-box p {
                font-size: 16px;
                margin: 10px 0;
            }
            .label {
                font-weight: bold;
            }
        </style>
    </head>
    <body>
        <div class='certificate-box'>
            <h2>Certificate Details</h2>";

    echo "<p><span class='label'>Deliverable ID:</span> " . $row['cert_id'] . "</p>";
    echo "<p><span class='label'>Published On:</span> " . $row['published_on'] . "</p>";
    echo "<p><span class='label'>QR Code Status:</span> " . $row['qr_code_status'] . "</p>";
    echo "<p><span class='label'>Name:</span> " . $row['name'] . "</p>";
    echo "<p><span class='label'>ID:</span> " . $row['person_id'] . "</p>";
    echo "<p><span class='label'>Issued On:</span> " . $row['issued_on'] . "</p>";
    echo "<p><span class='label'>Valid Until:</span> " . $row['valid_until'] . "</p>";
    echo "<p><span class='label'>Type:</span> " . $row['course_type'] . "</p>";
    echo "<p><span class='label'>Model:</span> " . $row['model'] . "</p>";
    echo "<p><span class='label'>Company:</span> " . $row['company'] . "</p>";
    echo "<p><span class='label'>Training Location:</span> " . $row['training_location'] . "</p>";
    echo "<p><span class='label'>Trainer:</span> " . $row['trainer_name'] . "</p>";

    echo "</div>
    </body>
    </html>";
} else {
    echo "<!DOCTYPE html>
    <html>
    <head><title>No Certificate Found</title></head>
    <body style='text-align: center; font-family: Arial; margin-top: 100px;'>
        <h2>Certificate not found.</h2>
    </body>
    </html>";
}
?>