<?php
require_once 'qrlib/phpqrcode/qrlib.php'; // if you want to regenerate QR code

// OLD DB
$oldDb = new mysqli("localhost", "buracyqv_user", "Red@apple@2299", "buracyqv_dbname");
if ($oldDb->connect_error) die("Old DB failed: " . $oldDb->connect_error);

// NEW DB (Remote)
$newDb = new mysqli("srv2067.hstgr.io", "u175020854_mydbuser", "RedVertius@1221", "u175020854_mydbname");
if ($newDb->connect_error) die("Remote DB failed: " . $newDb->connect_error);

// Read POST
$cert_id           = $_POST['cert_id'];
$published_on      = $_POST['published_on'];
$qr_code_status    = $_POST['qr_code_status'];
$name              = $_POST['name'];
$person_id         = $_POST['person_id'];
$issued_on         = $_POST['issued_on'];
$valid_until       = $_POST['valid_until'];
$course_type       = $_POST['course_type'];
$model             = $_POST['model'];
$company           = $_POST['company'];
$training_location = $_POST['training_location'];
$trainer_name      = $_POST['trainer_name'];
$alignment         = $_POST['alignment'];

// Update query
$query = "UPDATE certificates SET 
    published_on=?, qr_code_status=?, name=?, person_id=?, issued_on=?, valid_until=?, 
    course_type=?, model=?, company=?, training_location=?, trainer_name=?, alignment=? 
    WHERE cert_id=?";

// OLD DB update
$oldStmt = $oldDb->prepare($query);
$oldStmt->bind_param("sssssssssssss", $published_on,$qr_code_status,$name,$person_id,$issued_on,$valid_until,$course_type,$model,$company,$training_location,$trainer_name,$alignment,$cert_id);
$okOld = $oldStmt->execute();

// NEW DB update
$newStmt = $newDb->prepare($query);
$newStmt->bind_param("sssssssssssss", $published_on,$qr_code_status,$name,$person_id,$issued_on,$valid_until,$course_type,$model,$company,$training_location,$trainer_name,$alignment,$cert_id);
$okNew = $newStmt->execute();

if ($okOld && $okNew) {
    echo "<h2 style='color:green;'>✅ Certificate Updated Successfully!</h2>";
    echo "<p><a href='list_certificates.php'>← Back to List</a></p>";
} else {
    echo "<h2 style='color:red;'>❌ Update Failed</h2>";
    if (!$okOld) echo "<p>Old DB Error: " . htmlspecialchars($oldStmt->error) . "</p>";
    if (!$okNew) echo "<p>New DB Error: " . htmlspecialchars($newStmt->error) . "</p>";
    echo "<p><a href='edit_certificate.php?id=".urlencode($cert_id)."'>← Back to Edit</a></p>";
}
?>