<?php
// =======================
// edit_certificate.php with styled form
// =======================
require_once 'auth.php';
require_admin();

// DB connections
$oldDb = new mysqli("localhost", "buracyqv_user", "Red@apple@2299", "buracyqv_dbname");
$newDb = new mysqli("srv2067.hstgr.io", "u175020854_mydbuser", "RedVertius@1221", "u175020854_mydbname");
if ($oldDb->connect_error || $newDb->connect_error) die("DB connection failed.");

$cert_id = $_GET['id'];

// Fetch existing data from OLD DB
$stmt = $oldDb->prepare("SELECT * FROM certificates WHERE cert_id=?");
$stmt->bind_param("s", $cert_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows == 0) die("Certificate not found.");
$data = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Certificate</title>
    <style>
        body {font-family:'Segoe UI',sans-serif;background:linear-gradient(135deg,#dbe4ff,#f8f9fa);padding:40px;}
        .container{max-width:750px;margin:auto;background:white;padding:30px;border-radius:12px;box-shadow:0 4px 20px rgba(0,0,0,0.1);}        
        h2{text-align:center;margin-bottom:25px;color:#333;}
        label{font-weight:bold;display:block;margin-top:15px;color:#555;}
        input,select{width:100%;padding:10px;margin-top:5px;border:1px solid #ccc;border-radius:8px;font-size:15px;}
        button{margin-top:30px;width:100%;padding:12px;background:#007bff;color:white;border:none;border-radius:8px;font-size:16px;cursor:pointer;}
        button:hover{background:#0056b3;}
        a{text-align:center;display:block;margin-top:20px;}
    </style>
</head>
<body>
<div class="container">
<h2>Edit Certificate</h2>
<form action="update_certificate.php" method="post">
    <input type="hidden" name="cert_id" value="<?= htmlspecialchars($data['cert_id']) ?>">

    <label>Name:</label>
    <input type="text" name="name" value="<?= htmlspecialchars($data['name']) ?>" required>

    <label>Published On:</label>
    <input type="date" name="published_on" value="<?= htmlspecialchars($data['published_on']) ?>">

    <label>QR Code Status:</label>
    <select name="qr_code_status">
        <option value="Validated" <?= $data['qr_code_status']=='Validated'?'selected':'' ?>>Validated</option>
        <option value="Non-Validated" <?= $data['qr_code_status']=='Non-Validated'?'selected':'' ?>>Non-Validated</option>
    </select>

    <label>Person ID:</label>
    <input type="text" name="person_id" value="<?= htmlspecialchars($data['person_id']) ?>">

    <label>Issued On:</label>
    <input type="date" name="issued_on" value="<?= htmlspecialchars($data['issued_on']) ?>">

    <label>Valid Until:</label>
    <input type="date" name="valid_until" value="<?= htmlspecialchars($data['valid_until']) ?>">

    <label>Course Type:</label>
    <input type="text" name="course_type" value="<?= htmlspecialchars($data['course_type']) ?>">

    <label>Model:</label>
    <input type="text" name="model" value="<?= htmlspecialchars($data['model']) ?>">

    <label>Company:</label>
    <input type="text" name="company" value="<?= htmlspecialchars($data['company']) ?>">

    <label>Training Location:</label>
    <input type="text" name="training_location" value="<?= htmlspecialchars($data['training_location']) ?>">

    <label>Trainer Name:</label>
    <input type="text" name="trainer_name" value="<?= htmlspecialchars($data['trainer_name']) ?>">

    <label>Alignment:</label>
    <select name="alignment">
        <option value="horizontal" <?= $data['alignment']=='horizontal'?'selected':'' ?>>Horizontal</option>
        <option value="vertical" <?= $data['alignment']=='vertical'?'selected':'' ?>>Vertical</option>
    </select>

    <button type="submit">Update Certificate</button>
</form>
<a href="list_certificates.php">← Back to List</a>
</div>
</body>
</html>